 ; Ŀ
 ;   Find instrument tags with a given set of strings.                     
 ;   Copyright 2004 by Rocket Software Ltd.                                
 ;   There are no armoured amphibians.                                     
 ; 

 ; Ŀ
 ;   Atlia - suck attribute values and positions from a block into a list. 
 ; 
 (DEFUN ATLIA (enam / entt tagg taglst pa)
  (while (and (setq entt (entget (setq enam (entnext enam))))
              (/= (cdr (assoc 0 entt)) "SEQEND"))
         (setq tagg (strcase (cdr (assoc 1 entt))))
         (setq pa (cdr (assoc 10 entt)))
         (setq taglst (append taglst (list (list tagg pa)))))
 taglst)
 ; Ŀ
 ;   Atlia end.                                                            
 ; 

 ; Ŀ
 ;   Atlist - suck attribute values from a block into a list.              
 ;   Not currently called.                                                 
 ; 
 (DEFUN ATLIST (enam / entt tagg taglst)
  (while (and (setq entt (entget (setq enam (entnext enam))))
              (/= (cdr (assoc 0 entt)) "SEQEND"))
         (setq tagg (strcase (cdr (assoc 1 entt))))
         (setq taglst (append taglst (list tagg))))
 taglst)
 ; Ŀ
 ;   Atlist end.                                                           
 ; 

 ; Ŀ
 ;   Costro - see if a string matches the first element in any sublist     
 ;   of a list.                                                            
 ;   Arguments: Malist, the master list.                                   
 ;              Str, the string to match.                                  
 ;   Returns a list of the second elements from matching sublists or nil.  
 ; 
 (DEFUN COSTRO (malist str / num frond sub)
  (setq num 0)
  (while (setq sub (nth num malist))
         (if (= (car sub) str)
             (setq frond (cons (cadr sub) frond)))
         (setq num (1+ num)))
 frond)
 ; Ŀ
 ;   Costro end.                                                           
 ; 

 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Strget - get a string.                                                
 ;   Arguments: Strp, a default string.                                    
 ;              Prom, a prompt.                                            
 ;              Cas, convert to upper case: T (or anything) or nil.        
 ;   Returns a string.                                                     
 ; 
 (DEFUN STRGET (strde prom cas / strp)
  (if (= (type strde) 'STR)
      (progn
           (setq strp (getstring t (strcat prom " <" strde ">:")))
           (if (/= strp "") (setq strde strp)))
      (setq strde (getstring t (strcat prom ": "))))
  (if cas (setq strde (strcase strde)))
 strde)
 ; Ŀ
 ;   Strget eng.                                                           
 ; 

 ; Ŀ
 ;   Tafi.                                                                 
 ; 
 (DEFUN C:TAFI (/ rad num str gnustr malist ss numf entt enam valist pa
                                                              poslst foond)
  (setq rad (/ (getvar "viewsize") 40))
 ; Ŀ
 ;   Get or update a list of strings.                                      
 ; 
  (if tafils
      (progn
           (setq num 0)
           (setq str (nth num tafils))
           (while (/= "" (setq gnustr (strget str "Attribute value" t)))
                  (if (/= gnustr " ")
                      (setq malist (cons gnustr malist)))
                  (setq num (1+ num))
                  (setq str (nth num tafils))))
      (while (/= "" (setq gnustr (strget nil "Attribute value" t)))
             (setq malist (cons gnustr malist))))
  (setq tafils (reverse malist))
 ; Ŀ
 ;   Get an ss: every block in the drawing with attributes.                
 ; 
  (setq ss (ssget "X" (list (cons 0 "insert") (cons 66 1))))
  (setq num 0)
  (setq numf 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))
         (setq num (1+ num))
         (setq valist (atlia enam))
         (setq numa 0)
         (setq stop ())
         (setq poslst ())
         (while (and (null stop) (setq str (nth numa tafils)))
                (setq numa (1+ numa))
                (if (setq foond (costro valist str))
                    (setq poslst (append poslst foond))
                    (setq stop t)))
         (if (null stop)
             (progn
                  (setq numf (1+ numf))
                  (mark pa rad 1)
                  (while (setq pa (car poslst))
                         (mark pa rad 7)
                         (setq poslst (cdr poslst))))))
  (write-line (strcat "\nMatcjhing blocks found: " (itoa numf)))
 (princ))